require "prefabutil"

local assets=
{
	Asset("ANIM", "anim/pinecone.zip"),
	Asset("ANIM", "anim/evergreen_new.zip"), --build
    Asset("ANIM", "anim/evergreen_new_2.zip"), --build
    Asset("ANIM", "anim/evergreen_tall_old.zip"),
    Asset("ANIM", "anim/evergreen_short_normal.zip"),
    Asset("ANIM", "anim/emcbattery.zip"),
	--Asset("ANIM", "anim/dust_fx.zip"),
    Asset("SOUND", "sound/forest.fsb"),
}
local function DoIdleText(inst)
	local EMCper = inst.components.EMCglobalbuffer.EMC/inst.components.EMCglobalbuffer.maxEMC
	
	local ShowText = false
	local pt = Point(inst.Transform:GetWorldPosition())
	local ents = TheSim:FindEntities(pt.x,pt.y,pt.z, 4, nil, {"NOBLOCK", "FX", "INLIMBO", "DECOR"}) -- or we could include a flag to the search?
	for k, v in pairs(ents) do
		if v ~= inst and v.entity:IsValid() and v.entity:IsVisible() then
			if v:HasTag("player") then
				ShowText = true
			end
		end
	end
	
	if ShowText == true then
		inst.Label:SetText((math.floor(EMCper*1000+0.5)/10)) -- doesn't have a % O.o
		inst.Label:Enable(true)
	else
		inst.Label:Enable(false)
	end
end

local function DoIdle(inst)
	--local pt = Point(inst.Transform:GetWorldPosition())
	--print("EMCbattery is in "..GetWorld().Map:GetTileAtPoint(pt.x, pt.y, pt.z))
	inst.components.EMCglobalbuffer:BalanceGlobal(500)
	local EMCper = inst.components.EMCglobalbuffer.EMC/inst.components.EMCglobalbuffer.maxEMC
	
	
	--updateing look
	if EMCper > 0.90 then
		inst.AnimState:PlayAnimation("3")
	elseif EMCper > 0.55 then
		inst.AnimState:PlayAnimation("2")
	elseif EMCper > 0.25 then
		inst.AnimState:PlayAnimation("1")
	else
		inst.AnimState:PlayAnimation("0")
	end
	
end

local function StopIdling(inst)
    if inst.idletask then
        inst.idletask:Cancel()
        inst.idletask = nil
    end
	if inst.idletaskText then
        inst.idletaskText:Cancel()
        inst.idletaskText = nil
    end
end

local function StartIdling(inst)	
	if not inst.idletask then
		inst.idletask = inst:DoPeriodicTask(0.05, DoIdle)
	end
	if not inst.idletaskText then
		inst.idletaskText = inst:DoPeriodicTask(1, DoIdleText)
	end
end


local function onhammered(inst, worker)
	--inst.components.lootdropper:DropLoot()
	--inst.components.container:DropEverything()
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")	
	inst:Remove()
end

local function onhit(inst, worker)

end

local function onbuilt(inst)
	inst.components.EMCglobalbuffer.EMC = 25*3000

end




local function OnSave(inst, data)
    --if inst.EEupgraded and inst.EEupgraded == true then
        --data["EEUpGr"] = "yes"
    --end
end

local function OnLoad(inst, data)
    --[[if data and data["EEUpGr"] then
		--print("EEUpGr:"..data["EEUpGr"])
		inst.EEupgraded = true
	else
		print("no EEupgraded")
		inst.EEupgraded = false
	end--]]
end
		
local function init()
	local fn = function(Sim)
		local inst = CreateEntity()
		inst.entity:AddTransform()
		inst.entity:AddAnimState()
		inst.entity:AddSoundEmitter()
		--local minimap = inst.entity:AddMiniMapEntity()
		
		--minimap:SetIcon( "birdcage.png" )
		
		inst.entity:AddLabel()
		inst.Label:SetFontSize(24)
		inst.Label:SetFont(TALKINGFONT)
		inst.Label:SetPos(0,1.5,0)
		inst.Label:SetColour(.5,.5,.5)
		inst.Label:SetText("0")
		inst.Label:Enable(false)
	

		inst:AddTag("structure")
		inst.AnimState:SetBank("emcbattery")
		inst.AnimState:SetBuild("emcbattery")
		inst.AnimState:PlayAnimation("0")
		
		
		inst:AddComponent("inspectable")
		
		--inst:AddComponent("lootdropper")
		inst:AddComponent("workable")
		inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
		inst.components.workable:SetWorkLeft(2)
		inst.components.workable:SetOnFinishCallback(onhammered)
		inst.components.workable:SetOnWorkCallback(onhit) 
		
		
		inst:ListenForEvent( "onbuilt", onbuilt)
		MakeSnowCovered(inst, .01)
		
		local light = inst.entity:AddLight()
		light:SetIntensity(0.3)
		light:SetRadius(2)
		light:SetColour(1/255, 1/255, 255/255)
		light:Enable(true)
		
		inst:AddComponent("EMCglobalbuffer")
		inst.components.EMCglobalbuffer.maxEMC = 300000
		StartIdling(inst)
		
		inst.OnSave = OnSave
		inst.OnLoad = OnLoad
	
		return inst
	end
	return fn
end



return	Prefab( "common/prefab/emcbattery", init(), assets),
		MakePlacer("common/prefab/emcbattery_placer", "emcbattery", "emcbattery", "3")


		
		
		